# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 7
# Experiment: PMxPM, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR7_strategy.txt
# LLM Suggested Fallback: D

def benevolent_illusionist(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:
        return "C"  # Start with cooperation to establish goodwill
    
    # Detect unconditional strategies
    always_c = "return 'c'" in opponent_program_code.lower() or "always cooperate" in opponent_program_code.lower()
    always_d = "return 'd'" in opponent_program_code.lower() or "always defect" in opponent_program_code.lower()
    
    if always_c:
        return "D"  # Exploit always-C opponents
    if always_d:
        return "D"  # Minimize losses against always-D opponents
    
    # Check for recent defections to trigger retaliation
    if len(opp_history) >= 1 and opp_history[-1] == "D":
        if len(my_history) >= 1 and my_history[-1] == "D":
            if len(my_history) >= 2 and my_history[-2] == "D":
                return "C" if random.random() < 0.1 else "D"  # Randomly test tolerance
            else:
                return "D"  # Second retaliation
        else:
            return "D"  # First retaliation
    
    # Check for cooperation streak to revert to cooperation
    if len(opp_history) >= 2 and opp_history[-1] == "C" and opp_history[-2] == "C":
        return "C"
    
    # Random defect to test opponent's tolerance
    if random.random() < 0.1:
        return "D"
    
    return "C"  # Default to cooperation